
Imports NetShopForge.Library.Cart
Imports NetShopForge.Library.Address
Imports System.Collections.Generic
Imports NetShopForge.Library.Shipping
Imports NetShopForge.Library.Payment

Partial Class Shop_Cart_Controls_BillingShippingControl
    Inherits System.Web.UI.UserControl

#Region "---Public Property---"
    Public Property SelectedAddress() As AddressInfo
        Get

            'return the entered text bits as an address
            Dim address As New AddressInfo
            address.Address1 = txtSAddress.Text
            address.City = txtSCity.Text
            address.FirstName = txtSName.Text
            address.Phone = txtSPhone.Text
            address.Zip = txtSPostCode.Text
            address.Province = StateControlShipping.Text

            Return Address

        End Get
        Set(ByVal value As AddressInfo)
            txtSAddress.Text = value.Address1
            txtSCity.Text = value.City
            txtSName.Text = value.FirstName
            txtSPhone.Text = value.Phone
            txtSPostCode.Text = value.Zip
            StateControlShipping.Text = value.Province
        End Set
    End Property

#End Region

#Region "---Event Method---"

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load

        If Not IsPostBack Then
            BindAddressList()
            BindShippingItem()
            BindShippingRegion()
            BindData()
            lnkToggle.Text = "򿪵ַ"
            pnlAddBook.Visible = False
            lbTotalPrice.Text = String.Format("{0:c}", "203.52")
        End If

    End Sub

    Protected Sub lnkToggle_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles lnkToggle.Click
        If pnlAddBook.Visible Then
            lnkToggle.Text = "򿪵ַ"
            pnlAddBook.Visible = False
        Else
            lnkToggle.Text = "رյַ"
            pnlAddBook.Visible = True
        End If
    End Sub

    Protected Sub dtAddresses_ItemCommand(ByVal source As Object, ByVal e As System.Web.UI.WebControls.DataListCommandEventArgs) Handles dtAddresses.ItemCommand
        Dim lblID As Label = CType(e.Item.FindControl("lblAddressID"), Label)
        If Not lblID Is Nothing Then
            Dim shipAddressID As Integer = Integer.Parse(lblID.Text)
            Dim shipAddress As AddressInfo
            Dim objAC As New AddressController
            shipAddress = objAC.GetAddress(shipAddressID)
            Me.SelectedAddress = shipAddress
            lnkToggle.Text = "򿪵ַ"
            pnlAddBook.Visible = False
        End If
    End Sub

    Protected Sub ddlShippingRegion_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles ddlShippingRegion.SelectedIndexChanged
        If ddlShippingRegion.SelectedIndex = 0 Then
            rpShippingMethod.DataSource = Nothing
            rpShippingMethod.DataBind()
            rpPayment.DataSource = Nothing
            rpPayment.DataBind()
        Else
            Dim regionID As Integer = CInt(ddlShippingRegion.SelectedValue)
            BindShipingMethod(regionID)

            ''bind first ShippingMethod(default shippingMethod) 
            'If rpShippingMethod.Items.Count > 0 Then
            '    Dim rbShippingMethod As RadioButton = CType(rpShippingMethod.Items(0).FindControl("rbShippingMethod"), RadioButton)
            '    rbShippingMethod.Checked = True
            '    Dim hfShippingMethodID As HiddenField = CType(rpShippingMethod.Items(0).FindControl("hfShippingMethodID"), HiddenField)

            '    BindPaymentMethod(CInt(hfShippingMethodID.Value))
            '    'Bind first paymentMethod(default paymenthod)
            '    If rpPayment.Items.Count > 0 Then
            '        Dim rbPayment As RadioButton = CType(rpPayment.Items(0).FindControl("rbPayment"), RadioButton)
            '        rbPayment.Checked = True
            '    End If
            'Else
            '    rpPayment.DataSource = Nothing
            '    rpPayment.DataBind()
            'End If
        End If

    End Sub

    Protected Sub rbShippingMethod_CheckedChanged(ByVal source As Object, ByVal e As System.EventArgs)

        Dim i As Integer = 0
        For i = 0 To rpShippingMethod.Items.Count - 1
            Dim rbShippingMethod As RadioButton = CType(rpShippingMethod.Items(i).FindControl("rbShippingMethod"), RadioButton)
            If Not IsNothing(rbShippingMethod) AndAlso rbShippingMethod.Checked Then
                rbShippingMethod.Checked = True
                Dim hfShippingMethodID As HiddenField = CType(rpShippingMethod.Items(i).FindControl("hfShippingMethodID"), HiddenField)
                Dim LiteralShippingFee As Literal = CType(rpShippingMethod.Items(i).FindControl("LiteralShippingFee"), Literal)
                LiteralShippingFee.Text = Now.ToShortTimeString
                BindPaymentMethod(CInt(hfShippingMethodID.Value))
            End If
        Next

    End Sub

    Protected Sub rpShippingMethod_ItemDataBound(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.RepeaterItemEventArgs) Handles rpShippingMethod.ItemDataBound

        If e.Item.ItemType = ListItemType.Item Or e.Item.ItemType = ListItemType.AlternatingItem Then
            Dim hfShippingMethodID As HiddenField = CType(e.Item.FindControl("hfShippingMethodID"), HiddenField)

        End If
    End Sub

    Protected Sub btnUseCoupon_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnUseCoupon.Click
        Dim random As Random = New Random()

        lbTotalPrice.Text = String.Format("{0:c}", random.Next(1, 10000))
    End Sub


#End Region

#Region "---Private Method---"
    Private Sub BindData()
        'bind address
        Dim address As AddressInfo = Profile.LastShippingAddress
        If Not IsNothing(address) Then SelectedAddress = address


    End Sub
    Private Sub BindShippingItem()
        'bind Product 
        Dim cartCollection As ICollection(Of CartInfo) = Profile.ShoppingCart.CartCollection
        If cartCollection.Count > 0 Then
            gvCart.DataSource = cartCollection
            gvCart.DataBind()
        Else
            gvCart.DataSource = Nothing
            gvCart.DataBind()
        End If
    End Sub
    Private Sub BindAddressList()
        Dim objAc As New Address.AddressController
        dtAddresses.DataSource = objAc.GetAddressList(My.User.Name)
        dtAddresses.DataBind()

    End Sub

    Private Sub BindShippingRegion()
        Dim objSC As New ShippingController

        ddlShippingRegion.DataTextField = "Name"
        ddlShippingRegion.DataValueField = "ShippingRegionID"
        ddlShippingRegion.DataSource = objSC.GetShippingRegionList
        ddlShippingRegion.DataBind()
        ddlShippingRegion.Items.Insert(0, "<ѡ>")
    End Sub
    Private Sub BindShipingMethod(ByVal regionID As Integer)
        Dim objSC As New ShippingController
        rpShippingMethod.DataSource = objSC.GetShippingMethodList(regionID)
        rpShippingMethod.DataBind()
    End Sub
    Private Sub BindPaymentMethod(ByVal ShippingMethodID As Integer)
        Dim objSC As New ShippingController
        Dim objShipping As ShippingMethodInfo = objSC.GetShippingMethod(ShippingMethodID)
        Dim objPC As New Payment.PaymentController
        rpPayment.DataSource = objPC.GetPaymentMethodList(objShipping.PaymentMethodCollection)
        rpPayment.DataBind()

   
    End Sub



#End Region

    


End Class
